
### LimitCycleSystem ###

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
from scipy.integrate import solve_ivp
import math

# odeint needs a function  variables by this order(X,t).
# solve_ivp needs the function with the variable order (t,X).

t = np.linspace(0., 600., 6001)    # time spacing # ((tmax-tmin)/step)+1

# initial conditions
X1 = 1.2
X2 = 1
X0 = [X1,X2]

a1 = 1.02  # 0.9
h = 0.2  # 0.2
arg = (a1,h)

def fun(X,t, a1, h):
    X1, X2 = X

    dXdt = [
        a1 * (X1 ** 0.4 * X2 ** (-0.15) - X1 ** h),  # dX1dt differential equation for X1
        X1 - X2 ** 0.2                           # dX2dt differential equation for X2

    ]
    return dXdt

sol = odeint(fun, y0 = X0, t = t, args = arg)        # call solver

X1 = sol[:, 0]
X2 = sol[:, 1]


fig, axs = plt.subplots(2,1)
# Graph plotting
axs[0].plot(t, X1, label="X1")
axs[0].plot(t, X2, label="X2")
axs[0].set(xlabel='t', ylabel='')
axs[0].grid()
axs[0].legend(loc="best")

axs[1].plot(X1, X2)
axs[1].set(xlabel='X1', ylabel='X2')
axs[1].grid()
plt.show()
